#include <iostream>
#include <string>

#include "eval.h"
#include "defs.h"
#include "pawntab.h"
#include "squares.h"
#include "bits.h"

void cEval::score_queens(cBoard &brd, cMaterial &mat)
{
    uint pcenum;
	uint piece;
	uint *board = brd.p2board();
	uint sq;
	uint enemy;
	uint rank;
	uint file;
	uint oppkingrank;
    u64 wocc;
    u64 bocc;

    wocc = mat.getboard(pwP);
    bocc = mat.getboard(pbP);

	piece = pwQ;
	enemy = cB;

	pcenum = mat.getpcenum(piece);
    ASS(pcenum<maxpiecenum);

    oppkingrank = ranks[mat.getkingsq(cB)];

    ASS(oppkingrank>=RANK1&&oppkingrank<=RANK8);


    while(pcenum)
    {
      sq = mat.getpcesq(piece, pcenum);

      ASS(onbrd(sq));
      ASS(board[sq]==piece);

      file = files[sq];
      rank = ranks[sq];

      ASS(file>=FILEA&&file<=FILEH);
      ASS(rank>=RANK1&&rank<=RANK8);

      if(rank==RANK7 && ( RANKOCC(bocc, rank) || oppkingrank >= RANK7) )
      {
          pos[cW][OPE] += queenseventhrank;
          pos[cW][END] += queenseventhrank;
      }
      pcenum--;
    }

    piece = pbQ;
	enemy = cB;

	pcenum = mat.getpcenum(piece);
    ASS(pcenum<maxpiecenum);

    oppkingrank = ranks[mat.getkingsq(cW)];

    ASS(oppkingrank>=RANK1&&oppkingrank<=RANK8);

    while(pcenum)
    {
      sq = mat.getpcesq(piece, pcenum);

      ASS(onbrd(sq));
      ASS(board[sq]==piece);

      file = files[sq];
      rank = ranks[sq];

      ASS(file>=FILEA&&file<=FILEH);
      ASS(rank>=RANK1&&rank<=RANK8);

      if(rank==RANK2 && ( RANKOCC(wocc, rank) || oppkingrank <= RANK2) )
      {
          pos[cB][OPE] += queenseventhrank;
          pos[cB][END] += queenseventhrank;
      }
      pcenum--;
    }
}